<?php

include_once 'libs/mpdf60/mpdf.php';

class pdfController extends mPDF{

    private $template = 'controllers/componentes/pdf/templates';

    public  function __construct($template,$mensaje) {

        if($this->generarPdf($template,$mensaje)){
            return true;
        } else {
            false;
        }
    }
    
    public function generarPdf($template,$mensaje){
                      
        $html = $this->builtTemplate($template,$mensaje);
        $pdf = new mPDF();
        $pdf->setHeader('Tanya Lasses Eventos - Sistema de Inclusión de Trabajos Libres','O');
        $pdf->setFooter('{PAGENO}');
        $pdf->WriteHTML($html);
        $pdf->Output('finalizar_trabajo_libre.pdf' , 'I');
        exit;
    }
    
    public function builtTemplate($template,$contents){
        $file = $this->template . '/' . $template ;
        
        if(file_exists($file) && is_readable($file)){
            $handle = fopen($file, 'rb');
            $data = htmlspecialchars(fread($handle, filesize($file)));
        }

        $keys = array_keys($contents);
        
        if(is_array($contents)){
            foreach ($keys as $key){
                $data = str_replace("{{{$key}}}", $contents[$key], $data);
            }
        }
        return htmlspecialchars_decode($data);
    }

    }